require( "scripts/style.lua" );


local yes="Yes" ;
local no="No" ;	
	
if (gDialogTable.yeslabel) then
	yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
	no = gDialogTable.nolabel ;
end

if(InGame()) then
	PauseAnims(true);
end

MakeDialog
{
    Bitmap
    {
        name="yesnobackground",
		image="backgrounds/dialog",
		x=kCenter,
		y=kCenter,
        
        Button
        {
			command=
				function()
					PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) ); --QuitApplication();
				end;
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
            close = true,
            flags = 5,
            label = "yes",
            name = "yes",
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
            x = 255,
            y = 315,
        },
        Button
        {
			command=
				function()
					if(InGame()) then
						PauseAnims(false);
					end
					PopModal();
                end;
            font = StandardButtonFont,
			graphics = StandardButtonGraphics,
            close = true,
            flags = 5,
            label = "no",
            name = "no",
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
            x = 430,
            y = 315,
        },
        
        Text
		{
			font = DialogTitleFont,
			name = "yesnotitle",
			x=12, y=175,
			w=kMax,h=50,
			flags = kVAlignCenter + kHAlignCenter,
			label= "ui.dialog.quit.title",
		};
		
		Text
		{
			font = DialogBodyFont,
			name = "yesnobody",
			x=12,y=240,
			w=kMax,h=50,
			flags = kVAlignCenter + kHAlignCenter,
			label= "ui.dialog.quit.confirm",
		};
    },

} -- MakeDialog